from flask import Blueprint, Response
import requests
import base64
import json

duktek_bp = Blueprint('duktek', __name__)

@duktek_bp.route('/duktek')
def duktekplaylist():
    headers = {
        'Accept': '*/*',
        'Accept-Language': 'en-GB,en;q=0.5',
        'Referer': 'https://livingabroad.tv/',
        'Content-Type': 'application/json',
        'Origin': 'https://livingabroad.tv',
    }

    json_data = {
        'data': None,
    }

    response = requests.post(
        'https://jsaghdf6u534vmnv5df67rh-23487vhsd.blogspot.com/feeds/posts/default?alt=json'
    ).json()

    response = response['feed']['entry'][2]['content']["$t"]
    response = base64.b64decode(response).decode('utf-8')

    responsestring = json.loads(response)

    m3uplaylist = '#EXTM3U\n\n'

    for channel in responsestring:
        m3uplaylist += f'#EXTINF:-1 tvg-logo="{channel["gbr_base64"]}",{channel["nama_channel"]}\n#KODIPROP:inputstream.adaptive.license_type=clearkey\n#KODIPROP:inputstream.adaptive.license_key={channel['url_license']}\n{channel["url_iptv"]}\n\n'


    return Response(m3uplaylist, mimetype='audio/x-mpegurl')
